#include "stdafx.h"
#include <windows.h>
#include <crtdbg.h>
#include <tchar.h>
#include "utilities.h"
#include "material.h"
#include "bezier.h"

#ifdef RW_PATCH_EXP

#include "rppatch.h"

#endif /* RW_PATCH_EXP */

#if (!defined(BEZSIZE))
#define BEZSIZE 8
#endif /* (!defined(BEZSIZE)) */


#define MaxTriMatrixEvaluateMacro(_out, _P, _u, _v)                     \
    do                                                                  \
    {                                                                   \
        const RwReal u1 = (_u);                                         \
        const RwReal u2 = u1 * u1;                                      \
        const RwReal u3 = u1 * u2;                                      \
        const RwReal u4 = u1 * u3;                                      \
                                                                        \
        const RwReal v1 = (_v);                                         \
        const RwReal v2 = v1 * v1;                                      \
        const RwReal v3 = v1 * v2;                                      \
        const RwReal v4 = v1 * v3;                                      \
                                                                        \
        const RwReal w1 = 1 - (u1 + v1);                                \
        const RwReal w2 = w1 * w1;                                      \
        const RwReal w3 = w1 * w2;                                      \
        const RwReal w4 = w1 * w3;                                      \
                                                                        \
        const Point3 * const V0 = &(_P)[0][0];                          \
        const Point3 * const A0 = &(_P)[0][1];                          \
        const Point3 * const A1 = &(_P)[0][2];                          \
        const Point3 * const A2 = &(_P)[0][3];                          \
        const Point3 * const V1 = &(_P)[0][4];                          \
        const Point3 * const A8 = &(_P)[1][0];                          \
        const Point3 * const I0 = &(_P)[1][1];                          \
        const Point3 * const I1 = &(_P)[1][2];                          \
        const Point3 * const A3 = &(_P)[1][3];                          \
        const Point3 * const A7 = &(_P)[2][0];                          \
        const Point3 * const I2 = &(_P)[2][1];                          \
        const Point3 * const A4 = &(_P)[2][2];                          \
        const Point3 * const A6 = &(_P)[3][0];                          \
        const Point3 * const A5 = &(_P)[3][1];                          \
        const Point3 * const V2 = &(_P)[4][0];                          \
                                                                        \
        (_out)->x = ( w4*V0->x +                                        \
                      4*u1*w3*A0->x +                                   \
                      6*u2*w2*A1->x +                                   \
                      4*u3*w1*A2->x +                                   \
                      u4*V1->x +                                        \
                      4*v1*u3*A3->x +                                   \
                      6*v2*u2*A4->x +                                   \
                      4*v3*u1*A5->x +                                   \
                      v4*V2->x +                                        \
                      4*w1*v3*A6->x +                                   \
                      6*w2*v2*A7->x +                                   \
                      4*w3*v1*A8->x +                                   \
                      12*u1*v1*w2*I0->x +                               \
                      12*u2*v1*w1*I1->x +                               \
                      12*u1*v2*w1*I2->x );                              \
        (_out)->y = ( w4*V0->y +                                        \
                      4*u1*w3*A0->y +                                   \
                      6*u2*w2*A1->y +                                   \
                      4*u3*w1*A2->y +                                   \
                      u4*V1->y +                                        \
                      4*v1*u3*A3->y +                                   \
                      6*v2*u2*A4->y +                                   \
                      4*v3*u1*A5->y +                                   \
                      v4*V2->y +                                        \
                      4*w1*v3*A6->y +                                   \
                      6*w2*v2*A7->y +                                   \
                      4*w3*v1*A8->y +                                   \
                      12*u1*v1*w2*I0->y +                               \
                      12*u2*v1*w1*I1->y +                               \
                      12*u1*v2*w1*I2->y );                              \
        (_out)->z = ( w4*V0->z +                                        \
                      4*u1*w3*A0->z +                                   \
                      6*u2*w2*A1->z +                                   \
                      4*u3*w1*A2->z +                                   \
                      u4*V1->z +                                        \
                      4*v1*u3*A3->z +                                   \
                      6*v2*u2*A4->z +                                   \
                      4*v3*u1*A5->z +                                   \
                      v4*V2->z +                                        \
                      4*w1*v3*A6->z +                                   \
                      6*w2*v2*A7->z +                                   \
                      4*w3*v1*A8->z +                                   \
                      12*u1*v1*w2*I0->z +                               \
                      12*u2*v1*w1*I1->z +                               \
                      12*u1*v2*w1*I2->z );                              \
                                                                        \
    }                                                                   \
    while (0)


/*************************************************************************/
typedef Point3      MaxTriRow[5];
typedef MaxTriRow   MaxTriMatrix[5];

/*************************************************************************/

typedef Point3      BezRow[4];
typedef BezRow      BezMatrix[4];

/*  ------------- creation d'une structure Pvertex ------------- */

typedef struct Pvertex Pvertex;
struct Pvertex
{
    RwReal              x[3];   /* position */
    RwReal              n[3];   /* normal */
    RwReal              nx[3];  /* correct normal */
    RwReal              t[2];   /* tex coord */
    RwInt32             mat;    /* material */
    RwInt32             state;  /* etat */
};

/*  ------------- creation d'une structure patch --------------- */
typedef struct Ppatch Ppatch;
struct Ppatch
{
    Pvertex            *p[16];  /* vertex pointeur */
    RxVertexIndex       id[16]; /* index sur control points */
    RwInt32             mat;    /* material */
    RwInt32             type;   /* trig or quad */
};

/*  ------------- creation d'une structure mat name ------------- */
typedef struct Pmaterial Pmaterial;
struct Pmaterial
{
    char                name[64];
};

/* ------------------------------------------------------------------- */

#ifdef RW_PATCH_EXP

#define  BezTriFit(P, B)                                                     \
    do                                                                       \
    {                                                                        \
        /* Row 0 */                                                          \
                                                                             \
        P[0][0].x = B[0][0].x;                                               \
        P[0][0].y = B[0][0].y;                                               \
        P[0][0].z = B[0][0].z;                                               \
                                                                             \
        P[0][1].x = (3 * B[0][1].x - 5 * B[0][0].x / 6 - 3 * B[0][2].x / 2 + \
                     B[0][3].x / 3);                                         \
        P[0][1].y = (3 * B[0][1].y - 5 * B[0][0].y / 6 - 3 * B[0][2].y / 2 + \
                     B[0][3].y / 3);                                         \
        P[0][1].z = (3 * B[0][1].z - 5 * B[0][0].z / 6 - 3 * B[0][2].z / 2 + \
                     B[0][3].z / 3);                                         \
                                                                             \
        P[0][2].x = (B[0][0].x / 3 - 3 * B[0][1].x / 2 + 3 * B[0][2].x -     \
                     5 * B[0][3].x / 6);                                     \
        P[0][2].y = (B[0][0].y / 3 - 3 * B[0][1].y / 2 + 3 * B[0][2].y -     \
                     5 * B[0][3].y / 6);                                     \
        P[0][2].z = (B[0][0].z / 3 - 3 * B[0][1].z / 2 + 3 * B[0][2].z -     \
                     5 * B[0][3].z / 6);                                     \
                                                                             \
        P[0][3].x = B[0][3].x;                                               \
        P[0][3].y = B[0][3].y;                                               \
        P[0][3].z = B[0][3].z;                                               \
                                                                             \
        /* Row 1 */                                                          \
        P[1][0].x = (3 * B[1][0].x - 5 * B[0][0].x / 6 - 3 * B[2][0].x / 2 + \
                     B[3][0].x / 3);                                         \
        P[1][0].y = (3 * B[1][0].y - 5 * B[0][0].y / 6 - 3 * B[2][0].y / 2 + \
                     B[3][0].y / 3);                                         \
        P[1][0].z = (3 * B[1][0].z - 5 * B[0][0].z / 6 - 3 * B[2][0].z / 2 + \
                     B[3][0].z / 3);                                         \
                                                                             \
        P[1][1].x = (B[0][0].x / 3 - 3 * B[0][1].x / 4 - 3 * B[0][2].x / 4 + \
                     B[0][3].x / 3 - 3 * B[1][0].x / 4 + 9 * B[1][1].x / 2 - \
                     3 * B[1][2].x / 4 - 3 * B[2][0].x / 4 -                 \
                     3 * B[2][1].x / 4 + B[3][0].x / 3);                     \
        P[1][1].y =                                                          \
            (B[0][0].y / 3 - 3 * B[0][1].y / 4 - 3 * B[0][2].y / 4 +         \
             B[0][3].y / 3 - 3 * B[1][0].y / 4 + 9 * B[1][1].y / 2 -         \
             3 * B[1][2].y / 4 - 3 * B[2][0].y / 4 - 3 * B[2][1].y / 4 +     \
             B[3][0].y / 3);                                                 \
        P[1][1].z =                                                          \
            (B[0][0].z / 3 - 3 * B[0][1].z / 4 - 3 * B[0][2].z / 4 +         \
             B[0][3].z / 3 - 3 * B[1][0].z / 4 + 9 * B[1][1].z / 2 -         \
             3 * B[1][2].z / 4 - 3 * B[2][0].z / 4 - 3 * B[2][1].z / 4 +     \
             B[3][0].z / 3);                                                 \
                                                                             \
        P[1][2].x = (3 * B[1][2].x - 5 * B[0][3].x / 6 - 3 * B[2][1].x / 2 + \
                     B[3][0].x / 3);                                         \
        P[1][2].y = (3 * B[1][2].y - 5 * B[0][3].y / 6 - 3 * B[2][1].y / 2 + \
                     B[3][0].y / 3);                                         \
        P[1][2].z = (3 * B[1][2].z - 5 * B[0][3].z / 6 - 3 * B[2][1].z / 2 + \
                     B[3][0].z / 3);                                         \
                                                                             \
        /* Row 2 */                                                          \
        P[2][0].x = (B[0][0].x / 3 - 3 * B[1][0].x / 2 + 3 * B[2][0].x -     \
                     5 * B[3][0].x / 6);                                     \
        P[2][0].y = (B[0][0].y / 3 - 3 * B[1][0].y / 2 + 3 * B[2][0].y -     \
                     5 * B[3][0].y / 6);                                     \
        P[2][0].z = (B[0][0].z / 3 - 3 * B[1][0].z / 2 + 3 * B[2][0].z -     \
                     5 * B[3][0].z / 6);                                     \
                                                                             \
        P[2][1].x = (B[0][3].x / 3 - 3 * B[1][2].x / 2 + 3 * B[2][1].x -     \
                     5 * B[3][0].x / 6);                                     \
        P[2][1].y = (B[0][3].y / 3 - 3 * B[1][2].y / 2 + 3 * B[2][1].y -     \
                     5 * B[3][0].y / 6);                                     \
        P[2][1].z = (B[0][3].z / 3 - 3 * B[1][2].z / 2 + 3 * B[2][1].z -     \
                     5 * B[3][0].z / 6);                                     \
                                                                             \
        /* Row 3 */                                                          \
        P[3][0].x = B[3][0].x;                                               \
        P[3][0].y = B[3][0].y;                                               \
        P[3][0].z = B[3][0].z;                                               \
    }                                                                        \
    while (0)

#define MaxTriFit(P,  B)                                                     \
    do                                                                       \
    {                                                                        \
        /*                                                                   \
         * See                                                               \
         * http://intratech.csl.com/bezfit/maxtri.htm                        \
         * file://Hera/techologies/Doc/MaxSDK/decompil/html/sdk6ybb.htm      \
         */                                                                  \
                                                                             \
        /* Row 0 */                                                          \
        P[0][0].x = B[0][0].x;                                               \
        P[0][0].y = B[0][0].y;                                               \
        P[0][0].z = B[0][0].z;                                               \
                                                                             \
        P[0][1].x = (4 * B[0][1].x - 13 * B[0][0].x / 12 - 3 * B[0][2].x +   \
                     4 * B[0][3].x / 3 - B[0][4].x / 4);                     \
        P[0][1].y = (4 * B[0][1].y - 13 * B[0][0].y / 12 - 3 * B[0][2].y +   \
                     4 * B[0][3].y / 3 - B[0][4].y / 4);                     \
        P[0][1].z = (4 * B[0][1].z - 13 * B[0][0].z / 12 - 3 * B[0][2].z +   \
                     4 * B[0][3].z / 3 - B[0][4].z / 4);                     \
                                                                             \
        P[0][2].x =                                                          \
            (13 * B[0][0].x / 18 - 32 * B[0][1].x / 9 + 20 * B[0][2].x / 3 - \
             32 * B[0][3].x / 9 + 13 * B[0][4].x / 18);                      \
        P[0][2].y =                                                          \
            (13 * B[0][0].y / 18 - 32 * B[0][1].y / 9 + 20 * B[0][2].y / 3 - \
             32 * B[0][3].y / 9 + 13 * B[0][4].y / 18);                      \
        P[0][2].z =                                                          \
            (13 * B[0][0].z / 18 - 32 * B[0][1].z / 9 + 20 * B[0][2].z / 3 - \
             32 * B[0][3].z / 9 + 13 * B[0][4].z / 18);                      \
                                                                             \
        P[0][3].x = (4 * B[0][1].x / 3 - B[0][0].x / 4 - 3 * B[0][2].x +     \
                     4 * B[0][3].x - 13 * B[0][4].x / 12);                   \
        P[0][3].y = (4 * B[0][1].y / 3 - B[0][0].y / 4 - 3 * B[0][2].y +     \
                     4 * B[0][3].y - 13 * B[0][4].y / 12);                   \
        P[0][3].z = (4 * B[0][1].z / 3 - B[0][0].z / 4 - 3 * B[0][2].z +     \
                     4 * B[0][3].z - 13 * B[0][4].z / 12);                   \
                                                                             \
        P[0][4].x = B[0][4].x;                                               \
        P[0][4].y = B[0][4].y;                                               \
        P[0][4].z = B[0][4].z;                                               \
                                                                             \
        /* Row 1 */                                                          \
        P[1][0].x = (4 * B[1][0].x - 13 * B[0][0].x / 12 - 3 * B[2][0].x +   \
                     4 * B[3][0].x / 3 - B[4][0].x / 4);                     \
        P[1][0].y = (4 * B[1][0].y - 13 * B[0][0].y / 12 - 3 * B[2][0].y +   \
                     4 * B[3][0].y / 3 - B[4][0].y / 4);                     \
        P[1][0].z = (4 * B[1][0].z - 13 * B[0][0].z / 12 - 3 * B[2][0].z +   \
                     4 * B[3][0].z / 3 - B[4][0].z / 4);                     \
                                                                             \
        P[1][1].x =                                                          \
            (13 * B[0][0].x / 18 - 16 * B[0][1].x / 9 - 2 * B[0][2].x / 3 +  \
             8 * B[0][3].x / 9 - B[0][4].x / 4 - 16 * B[1][0].x / 9 +        \
             8 * B[1][1].x - 8 * B[1][2].x / 3 + 4 * B[1][3].x / 9 -         \
             2 * B[2][0].x / 3 - 8 * B[2][1].x / 3 + B[2][2].x / 3 +         \
             8 * B[3][0].x / 9 + 4 * B[3][1].x / 9 - B[4][0].x / 4);         \
        P[1][1].y =                                                          \
            (13 * B[0][0].y / 18 - 16 * B[0][1].y / 9 - 2 * B[0][2].y / 3 +  \
             8 * B[0][3].y / 9 - B[0][4].y / 4 - 16 * B[1][0].y / 9 +        \
             8 * B[1][1].y - 8 * B[1][2].y / 3 + 4 * B[1][3].y / 9 -         \
             2 * B[2][0].y / 3 - 8 * B[2][1].y / 3 + B[2][2].y / 3 +         \
             8 * B[3][0].y / 9 + 4 * B[3][1].y / 9 - B[4][0].y / 4);         \
        P[1][1].z =                                                          \
            (13 * B[0][0].z / 18 - 16 * B[0][1].z / 9 - 2 * B[0][2].z / 3 +  \
             8 * B[0][3].z / 9 - B[0][4].z / 4 - 16 * B[1][0].z / 9 +        \
             8 * B[1][1].z - 8 * B[1][2].z / 3 + 4 * B[1][3].z / 9 -         \
             2 * B[2][0].z / 3 - 8 * B[2][1].z / 3 + B[2][2].z / 3 +         \
             8 * B[3][0].z / 9 + 4 * B[3][1].z / 9 - B[4][0].z / 4);         \
                                                                             \
        P[1][2].x = (8 * B[0][1].x / 9 - B[0][0].x / 4 - 2 * B[0][2].x / 3 - \
                     16 * B[0][3].x / 9 + 13 * B[0][4].x / 18 +              \
                     4 * B[1][0].x / 9 - 8 * B[1][1].x / 3 + 8 * B[1][2].x - \
                     16 * B[1][3].x / 9 + B[2][0].x / 3 -                    \
                     8 * B[2][1].x / 3 - 2 * B[2][2].x / 3 +                 \
                     4 * B[3][0].x / 9 + 8 * B[3][1].x / 9 - B[4][0].x / 4); \
        P[1][2].y =                                                          \
            (8 * B[0][1].y / 9 - B[0][0].y / 4 - 2 * B[0][2].y / 3 -         \
             16 * B[0][3].y / 9 + 13 * B[0][4].y / 18 + 4 * B[1][0].y / 9 -  \
             8 * B[1][1].y / 3 + 8 * B[1][2].y - 16 * B[1][3].y / 9 +        \
             B[2][0].y / 3 - 8 * B[2][1].y / 3 - 2 * B[2][2].y / 3 +         \
             4 * B[3][0].y / 9 + 8 * B[3][1].y / 9 - B[4][0].y / 4);         \
        P[1][2].z =                                                          \
            (8 * B[0][1].z / 9 - B[0][0].z / 4 - 2 * B[0][2].z / 3 -         \
             16 * B[0][3].z / 9 + 13 * B[0][4].z / 18 + 4 * B[1][0].z / 9 -  \
             8 * B[1][1].z / 3 + 8 * B[1][2].z - 16 * B[1][3].z / 9 +        \
             B[2][0].z / 3 - 8 * B[2][1].z / 3 - 2 * B[2][2].z / 3 +         \
             4 * B[3][0].z / 9 + 8 * B[3][1].z / 9 - B[4][0].z / 4);         \
                                                                             \
        P[1][3].x = (4 * B[1][3].x - 13 * B[0][4].x / 12 - 3 * B[2][2].x +   \
                     4 * B[3][1].x / 3 - B[4][0].x / 4);                     \
        P[1][3].y = (4 * B[1][3].y - 13 * B[0][4].y / 12 - 3 * B[2][2].y +   \
                     4 * B[3][1].y / 3 - B[4][0].y / 4);                     \
        P[1][3].z = (4 * B[1][3].z - 13 * B[0][4].z / 12 - 3 * B[2][2].z +   \
                     4 * B[3][1].z / 3 - B[4][0].z / 4);                     \
                                                                             \
        /* Row 2 */                                                          \
        P[2][0].x =                                                          \
            (13 * B[0][0].x / 18 - 32 * B[1][0].x / 9 + 20 * B[2][0].x / 3 - \
             32 * B[3][0].x / 9 + 13 * B[4][0].x / 18);                      \
        P[2][0].y =                                                          \
            (13 * B[0][0].y / 18 - 32 * B[1][0].y / 9 + 20 * B[2][0].y / 3 - \
             32 * B[3][0].y / 9 + 13 * B[4][0].y / 18);                      \
        P[2][0].z =                                                          \
            (13 * B[0][0].z / 18 - 32 * B[1][0].z / 9 + 20 * B[2][0].z / 3 - \
             32 * B[3][0].z / 9 + 13 * B[4][0].z / 18);                      \
                                                                             \
        P[2][1].x = (4 * B[0][1].x / 9 - B[0][0].x / 4 + B[0][2].x / 3 +     \
                     4 * B[0][3].x / 9 - B[0][4].x / 4 + 8 * B[1][0].x / 9 - \
                     8 * B[1][1].x / 3 - 8 * B[1][2].x / 3 +                 \
                     8 * B[1][3].x / 9 - 2 * B[2][0].x / 3 + 8 * B[2][1].x - \
                     2 * B[2][2].x / 3 - 16 * B[3][0].x / 9 -                \
                     16 * B[3][1].x / 9 + 13 * B[4][0].x / 18);              \
        P[2][1].y =                                                          \
            (4 * B[0][1].y / 9 - B[0][0].y / 4 + B[0][2].y / 3 +             \
             4 * B[0][3].y / 9 - B[0][4].y / 4 + 8 * B[1][0].y / 9 -         \
             8 * B[1][1].y / 3 - 8 * B[1][2].y / 3 + 8 * B[1][3].y / 9 -     \
             2 * B[2][0].y / 3 + 8 * B[2][1].y - 2 * B[2][2].y / 3 -         \
             16 * B[3][0].y / 9 - 16 * B[3][1].y / 9 + 13 * B[4][0].y / 18); \
        P[2][1].z =                                                          \
            (4 * B[0][1].z / 9 - B[0][0].z / 4 + B[0][2].z / 3 +             \
             4 * B[0][3].z / 9 - B[0][4].z / 4 + 8 * B[1][0].z / 9 -         \
             8 * B[1][1].z / 3 - 8 * B[1][2].z / 3 + 8 * B[1][3].z / 9 -     \
             2 * B[2][0].z / 3 + 8 * B[2][1].z - 2 * B[2][2].z / 3 -         \
             16 * B[3][0].z / 9 - 16 * B[3][1].z / 9 + 13 * B[4][0].z / 18); \
                                                                             \
        P[2][2].x =                                                          \
            (13 * B[0][4].x / 18 - 32 * B[1][3].x / 9 + 20 * B[2][2].x / 3 - \
             32 * B[3][1].x / 9 + 13 * B[4][0].x / 18);                      \
        P[2][2].y =                                                          \
            (13 * B[0][4].y / 18 - 32 * B[1][3].y / 9 + 20 * B[2][2].y / 3 - \
             32 * B[3][1].y / 9 + 13 * B[4][0].y / 18);                      \
        P[2][2].z =                                                          \
            (13 * B[0][4].z / 18 - 32 * B[1][3].z / 9 + 20 * B[2][2].z / 3 - \
             32 * B[3][1].z / 9 + 13 * B[4][0].z / 18);                      \
                                                                             \
        /* Row 3 */                                                          \
        P[3][0].x = (4 * B[1][0].x / 3 - B[0][0].x / 4 - 3 * B[2][0].x +     \
                     4 * B[3][0].x - 13 * B[4][0].x / 12);                   \
        P[3][0].y = (4 * B[1][0].y / 3 - B[0][0].y / 4 - 3 * B[2][0].y +     \
                     4 * B[3][0].y - 13 * B[4][0].y / 12);                   \
        P[3][0].z = (4 * B[1][0].z / 3 - B[0][0].z / 4 - 3 * B[2][0].z +     \
                     4 * B[3][0].z - 13 * B[4][0].z / 12);                   \
                                                                             \
        P[3][1].x = (4 * B[1][3].x / 3 - B[0][4].x / 4 - 3 * B[2][2].x +     \
                     4 * B[3][1].x - 13 * B[4][0].x / 12);                   \
        P[3][1].y = (4 * B[1][3].y / 3 - B[0][4].y / 4 - 3 * B[2][2].y +     \
                     4 * B[3][1].y - 13 * B[4][0].y / 12);                   \
        P[3][1].z = (4 * B[1][3].z / 3 - B[0][4].z / 4 - 3 * B[2][2].z +     \
                     4 * B[3][1].z - 13 * B[4][0].z / 12);                   \
                                                                             \
        /* Row 4 */                                                          \
        P[4][0].x = B[4][0].x;                                               \
        P[4][0].y = B[4][0].y;                                               \
        P[4][0].z = B[4][0].z;                                               \
    }                                                                        \
    while (0)

#define BezQuadFit(P, B)                                                     \
    do                                                                       \
    {                                                                        \
                                                                             \
        /* Row 0 */                                                          \
        P[0][0].x = B[0][0].x;                                               \
        P[0][0].y = B[0][0].y;                                               \
        P[0][0].z = B[0][0].z;                                               \
                                                                             \
        P[0][1].x = (3 * B[0][1].x - 5 * B[0][0].x / 6 - 3 * B[0][2].x / 2 + \
                     B[0][3].x / 3);                                         \
        P[0][1].y = (3 * B[0][1].y - 5 * B[0][0].y / 6 - 3 * B[0][2].y / 2 + \
                     B[0][3].y / 3);                                         \
        P[0][1].z = (3 * B[0][1].z - 5 * B[0][0].z / 6 - 3 * B[0][2].z / 2 + \
                     B[0][3].z / 3);                                         \
                                                                             \
        P[0][2].x = (B[0][0].x / 3 - 3 * B[0][1].x / 2 + 3 * B[0][2].x -     \
                     5 * B[0][3].x / 6);                                     \
        P[0][2].y = (B[0][0].y / 3 - 3 * B[0][1].y / 2 + 3 * B[0][2].y -     \
                     5 * B[0][3].y / 6);                                     \
        P[0][2].z = (B[0][0].z / 3 - 3 * B[0][1].z / 2 + 3 * B[0][2].z -     \
                     5 * B[0][3].z / 6);                                     \
                                                                             \
        P[0][3].x = B[0][3].x;                                               \
        P[0][3].y = B[0][3].y;                                               \
        P[0][3].z = B[0][3].z;                                               \
                                                                             \
        /* Row 1 */                                                          \
        P[1][0].x = (3 * B[1][0].x - 5 * B[0][0].x / 6 - 3 * B[2][0].x / 2 + \
                     B[3][0].x / 3);                                         \
        P[1][0].y = (3 * B[1][0].y - 5 * B[0][0].y / 6 - 3 * B[2][0].y / 2 + \
                     B[3][0].y / 3);                                         \
        P[1][0].z = (3 * B[1][0].z - 5 * B[0][0].z / 6 - 3 * B[2][0].z / 2 + \
                     B[3][0].z / 3);                                         \
                                                                             \
        P[1][1].x =                                                          \
            (25 * B[0][0].x / 36 - 5 * B[0][1].x / 2 + 5 * B[0][2].x / 4 -   \
             5 * B[0][3].x / 18 - 5 * B[1][0].x / 2 + 9 * B[1][1].x -        \
             9 * B[1][2].x / 2 + B[1][3].x + 5 * B[2][0].x / 4 -             \
             9 * B[2][1].x / 2 + 9 * B[2][2].x / 4 - B[2][3].x / 2 -         \
             5 * B[3][0].x / 18 + B[3][1].x - B[3][2].x / 2 +                \
             B[3][3].x / 9);                                                 \
        P[1][1].y =                                                          \
            (25 * B[0][0].y / 36 - 5 * B[0][1].y / 2 + 5 * B[0][2].y / 4 -   \
             5 * B[0][3].y / 18 - 5 * B[1][0].y / 2 + 9 * B[1][1].y -        \
             9 * B[1][2].y / 2 + B[1][3].y + 5 * B[2][0].y / 4 -             \
             9 * B[2][1].y / 2 + 9 * B[2][2].y / 4 - B[2][3].y / 2 -         \
             5 * B[3][0].y / 18 + B[3][1].y - B[3][2].y / 2 +                \
             B[3][3].y / 9);                                                 \
        P[1][1].z =                                                          \
            (25 * B[0][0].z / 36 - 5 * B[0][1].z / 2 + 5 * B[0][2].z / 4 -   \
             5 * B[0][3].z / 18 - 5 * B[1][0].z / 2 + 9 * B[1][1].z -        \
             9 * B[1][2].z / 2 + B[1][3].z + 5 * B[2][0].z / 4 -             \
             9 * B[2][1].z / 2 + 9 * B[2][2].z / 4 - B[2][3].z / 2 -         \
             5 * B[3][0].z / 18 + B[3][1].z - B[3][2].z / 2 +                \
             B[3][3].z / 9);                                                 \
                                                                             \
        P[1][2].x =                                                          \
            (5 * B[0][1].x / 4 - 5 * B[0][0].x / 18 - 5 * B[0][2].x / 2 +    \
             25 * B[0][3].x / 36 + B[1][0].x - 9 * B[1][1].x / 2 +           \
             9 * B[1][2].x - 5 * B[1][3].x / 2 - B[2][0].x / 2 +             \
             9 * B[2][1].x / 4 - 9 * B[2][2].x / 2 + 5 * B[2][3].x / 4 +     \
             B[3][0].x / 9 - B[3][1].x / 2 + B[3][2].x -                     \
             5 * B[3][3].x / 18);                                            \
        P[1][2].y =                                                          \
            (5 * B[0][1].y / 4 - 5 * B[0][0].y / 18 - 5 * B[0][2].y / 2 +    \
             25 * B[0][3].y / 36 + B[1][0].y - 9 * B[1][1].y / 2 +           \
             9 * B[1][2].y - 5 * B[1][3].y / 2 - B[2][0].y / 2 +             \
             9 * B[2][1].y / 4 - 9 * B[2][2].y / 2 + 5 * B[2][3].y / 4 +     \
             B[3][0].y / 9 - B[3][1].y / 2 + B[3][2].y -                     \
             5 * B[3][3].y / 18);                                            \
        P[1][2].z =                                                          \
            (5 * B[0][1].z / 4 - 5 * B[0][0].z / 18 - 5 * B[0][2].z / 2 +    \
             25 * B[0][3].z / 36 + B[1][0].z - 9 * B[1][1].z / 2 +           \
             9 * B[1][2].z - 5 * B[1][3].z / 2 - B[2][0].z / 2 +             \
             9 * B[2][1].z / 4 - 9 * B[2][2].z / 2 + 5 * B[2][3].z / 4 +     \
             B[3][0].z / 9 - B[3][1].z / 2 + B[3][2].z -                     \
             5 * B[3][3].z / 18);                                            \
                                                                             \
        P[1][3].x = (3 * B[1][3].x - 5 * B[0][3].x / 6 - 3 * B[2][3].x / 2 + \
                     B[3][3].x / 3);                                         \
        P[1][3].y = (3 * B[1][3].y - 5 * B[0][3].y / 6 - 3 * B[2][3].y / 2 + \
                     B[3][3].y / 3);                                         \
        P[1][3].z = (3 * B[1][3].z - 5 * B[0][3].z / 6 - 3 * B[2][3].z / 2 + \
                     B[3][3].z / 3);                                         \
                                                                             \
        /* Row 2 */                                                          \
        P[2][0].x = (B[0][0].x / 3 - 3 * B[1][0].x / 2 + 3 * B[2][0].x -     \
                     5 * B[3][0].x / 6);                                     \
        P[2][0].y = (B[0][0].y / 3 - 3 * B[1][0].y / 2 + 3 * B[2][0].y -     \
                     5 * B[3][0].y / 6);                                     \
        P[2][0].z = (B[0][0].z / 3 - 3 * B[1][0].z / 2 + 3 * B[2][0].z -     \
                     5 * B[3][0].z / 6);                                     \
                                                                             \
        P[2][1].x =                                                          \
            (B[0][1].x - 5 * B[0][0].x / 18 - B[0][2].x / 2 +                \
             B[0][3].x / 9 + 5 * B[1][0].x / 4 - 9 * B[1][1].x / 2 +         \
             9 * B[1][2].x / 4 - B[1][3].x / 2 - 5 * B[2][0].x / 2 +         \
             9 * B[2][1].x - 9 * B[2][2].x / 2 + B[2][3].x +                 \
             25 * B[3][0].x / 36 - 5 * B[3][1].x / 2 + 5 * B[3][2].x / 4 -   \
             5 * B[3][3].x / 18);                                            \
        P[2][1].y =                                                          \
            (B[0][1].y - 5 * B[0][0].y / 18 - B[0][2].y / 2 +                \
             B[0][3].y / 9 + 5 * B[1][0].y / 4 - 9 * B[1][1].y / 2 +         \
             9 * B[1][2].y / 4 - B[1][3].y / 2 - 5 * B[2][0].y / 2 +         \
             9 * B[2][1].y - 9 * B[2][2].y / 2 + B[2][3].y +                 \
             25 * B[3][0].y / 36 - 5 * B[3][1].y / 2 + 5 * B[3][2].y / 4 -   \
             5 * B[3][3].y / 18);                                            \
        P[2][1].z =                                                          \
            (B[0][1].z - 5 * B[0][0].z / 18 - B[0][2].z / 2 +                \
             B[0][3].z / 9 + 5 * B[1][0].z / 4 - 9 * B[1][1].z / 2 +         \
             9 * B[1][2].z / 4 - B[1][3].z / 2 - 5 * B[2][0].z / 2 +         \
             9 * B[2][1].z - 9 * B[2][2].z / 2 + B[2][3].z +                 \
             25 * B[3][0].z / 36 - 5 * B[3][1].z / 2 + 5 * B[3][2].z / 4 -   \
             5 * B[3][3].z / 18);                                            \
                                                                             \
        P[2][2].x =                                                          \
            (B[0][0].x / 9 - B[0][1].x / 2 + B[0][2].x -                     \
             5 * B[0][3].x / 18 - B[1][0].x / 2 + 9 * B[1][1].x / 4 -        \
             9 * B[1][2].x / 2 + 5 * B[1][3].x / 4 + B[2][0].x -             \
             9 * B[2][1].x / 2 + 9 * B[2][2].x - 5 * B[2][3].x / 2 -         \
             5 * B[3][0].x / 18 + 5 * B[3][1].x / 4 - 5 * B[3][2].x / 2 +    \
             25 * B[3][3].x / 36);                                           \
        P[2][2].y =                                                          \
            (B[0][0].y / 9 - B[0][1].y / 2 + B[0][2].y -                     \
             5 * B[0][3].y / 18 - B[1][0].y / 2 + 9 * B[1][1].y / 4 -        \
             9 * B[1][2].y / 2 + 5 * B[1][3].y / 4 + B[2][0].y -             \
             9 * B[2][1].y / 2 + 9 * B[2][2].y - 5 * B[2][3].y / 2 -         \
             5 * B[3][0].y / 18 + 5 * B[3][1].y / 4 - 5 * B[3][2].y / 2 +    \
             25 * B[3][3].y / 36);                                           \
        P[2][2].z =                                                          \
            (B[0][0].z / 9 - B[0][1].z / 2 + B[0][2].z -                     \
             5 * B[0][3].z / 18 - B[1][0].z / 2 + 9 * B[1][1].z / 4 -        \
             9 * B[1][2].z / 2 + 5 * B[1][3].z / 4 + B[2][0].z -             \
             9 * B[2][1].z / 2 + 9 * B[2][2].z - 5 * B[2][3].z / 2 -         \
             5 * B[3][0].z / 18 + 5 * B[3][1].z / 4 - 5 * B[3][2].z / 2 +    \
             25 * B[3][3].z / 36);                                           \
                                                                             \
        P[2][3].x = (B[0][3].x / 3 - 3 * B[1][3].x / 2 + 3 * B[2][3].x -     \
                     5 * B[3][3].x / 6);                                     \
        P[2][3].y = (B[0][3].y / 3 - 3 * B[1][3].y / 2 + 3 * B[2][3].y -     \
                     5 * B[3][3].y / 6);                                     \
        P[2][3].z = (B[0][3].z / 3 - 3 * B[1][3].z / 2 + 3 * B[2][3].z -     \
                     5 * B[3][3].z / 6);                                     \
                                                                             \
        /* Row 3 */                                                          \
        P[3][0].x = B[3][0].x;                                               \
        P[3][0].y = B[3][0].y;                                               \
        P[3][0].z = B[3][0].z;                                               \
                                                                             \
        P[3][1].x = (3 * B[3][1].x - 5 * B[3][0].x / 6 - 3 * B[3][2].x / 2 + \
                     B[3][3].x / 3);                                         \
        P[3][1].y = (3 * B[3][1].y - 5 * B[3][0].y / 6 - 3 * B[3][2].y / 2 + \
                     B[3][3].y / 3);                                         \
        P[3][1].z = (3 * B[3][1].z - 5 * B[3][0].z / 6 - 3 * B[3][2].z / 2 + \
                     B[3][3].z / 3);                                         \
                                                                             \
        P[3][2].x = (B[3][0].x / 3 - 3 * B[3][1].x / 2 + 3 * B[3][2].x -     \
                     5 * B[3][3].x / 6);                                     \
        P[3][2].y = (B[3][0].y / 3 - 3 * B[3][1].y / 2 + 3 * B[3][2].y -     \
                     5 * B[3][3].y / 6);                                     \
        P[3][2].z = (B[3][0].z / 3 - 3 * B[3][1].z / 2 + 3 * B[3][2].z -     \
                     5 * B[3][3].z / 6);                                     \
                                                                             \
        P[3][3].x = B[3][3].x;                                               \
        P[3][3].y = B[3][3].y;                                               \
        P[3][3].z = B[3][3].z;                                               \
    }                                                                        \
    while (0)

inline bool
IsNodeRwPatch(INode * node, TimeValue tvCurrent)
{

    Object             *const object =
        (node ?
         (node->EvalWorldState(tvCurrent).obj) : (Object *) NULL);
    PatchObject        *const patchObject =
        (object ? 
         ((PatchObject *) object->ConvertToType(tvCurrent,
                                                patchObjectClassID))
         : (PatchObject *) NULL);
    const bool          result =
        (((PatchObject *) NULL) != patchObject);

    RWEXPMESSAGE(("%s(%d): %d == IsNodeRwPatch(%p[%s], %f)\n",
                  __FILE__, __LINE__, result,
                  node, node ? node->GetName() : "NULL", tvCurrent));

    return result;
}

/*-------------------------------------------------------------------*/

void
GetTexFileName(char *outFileName, char *fullPathName, RwInt32 nameCase)
{
    RwInt32             strLen;
    char               *start, *end;
    BOOL                strippedext = FALSE;

    if (fullPathName)
    {

        if (start = strrchr(fullPathName, '\\'))
        {
            start++;
        }
        else
        {
            start = fullPathName;
        }

        if (end = strrchr(start, '.'))
        {
            *end = '\0';
            strippedext = TRUE;
        }
        else
        {
            end = start + strlen(start);
        }

        strLen = end - start;

        strncpy(outFileName, start, strLen + 1);
        outFileName[strLen] = '\0';
        if (strippedext)
            *end = '.';

        if (nameCase == 1)
        {
            strlwr(outFileName);
        }
        if (nameCase == 2)
        {
            strupr(outFileName);
        }
    }
    else
    {
        outFileName[0] = '\0';
    }

    return;
}

static void
GetBezBox(PatchObject * patchObject,
          RwReal box[3][2], RwInt32 * const quadpatches,
          RwInt32 * const tripatches)
{

    PatchMesh          *patchmesh;
    RwInt32             numquadpatches = 0;
    RwInt32             numtripatches = 0;
    RwInt32             numverts;
    RwInt32             vecoffset;
    RwInt32             patch;

    _ASSERTE(patchObject);
    patchmesh = &patchObject->patch;

    _ASSERTE(patchmesh);
    vecoffset = patchmesh->numVerts;
    numverts = vecoffset + patchmesh->numVecs;

    box[0][0] = HUGE_VAL;
    box[0][1] = -HUGE_VAL;
    box[1][0] = HUGE_VAL;
    box[1][1] = -HUGE_VAL;
    box[2][0] = HUGE_VAL;
    box[2][1] = -HUGE_VAL;

    for (patch = 0; patch < patchmesh->numPatches; patch++)
    {
        RwInt32             i;
        RwInt32             j;
        Point3              vert;
        Patch              *p;
        BezMatrix           P;
        BezMatrix           B;

        p = &patchmesh->patches[patch];
        _ASSERTE(p);

        if (p->type == PATCH_TRI)
        {
            RwReal              b[3];

            numtripatches++;
            for (j = 0; j <= 3; j++)
            {
                b[0] = ((RwReal) j) / ((RwReal)3);
                for (i = 0; i <= (3 - j); i++)
                {
                    b[1] = ((RwReal) i) / ((RwReal)3);
                    b[2] = 1 - (b[0] + b[1]);
                    B[i][j] = p->interp(patchmesh, b[0], b[1], b[2]);
                }
            }

            BezTriFit(P, B);

            for (j = 0; j <= 3; j++)
            {
                for (i = 0; i <= (3-j); i++)
                {
                    vert = P[j][i];
                    box[0][0] = (vert.x < box[0][0]) ? vert.x : box[0][0];
                    box[0][1] = (vert.x > box[0][1]) ? vert.x : box[0][1];
                    box[1][0] = (vert.y < box[1][0]) ? vert.y : box[1][0];
                    box[1][1] = (vert.y > box[1][1]) ? vert.y : box[1][1];
                    box[2][0] = (vert.z < box[2][0]) ? vert.z : box[2][0];
                    box[2][1] = (vert.z > box[2][1]) ? vert.z : box[2][1];
                }
            }
        }  /*  (p->type == PATCH_TRI) */
        else if (p->type == PATCH_QUAD)
        {
            RwReal              b[2];

            numquadpatches++;

            for (j = 0; j <= 3; j++)
            {
                b[0] = ((RwReal) j) / ((RwReal)3);
                for (i = 0; i <= 3; i++)
                {
                    b[1] = ((RwReal) i) / ((RwReal)3);
                    B[i][j] = p->interp(patchmesh, b[1], b[0]);
                }
            }
            /* ---- build positions ---- */
            BezQuadFit(P, B);

            for (j = 0; j <= 3; j++)
            {
                for (i = 0; i <= 3; i++)
                {
                    vert = P[j][i];
                    box[0][0] = (vert.x < box[0][0]) ? vert.x : box[0][0];
                    box[0][1] = (vert.x > box[0][1]) ? vert.x : box[0][1];
                    box[1][0] = (vert.y < box[1][0]) ? vert.y : box[1][0];
                    box[1][1] = (vert.y > box[1][1]) ? vert.y : box[1][1];
                    box[2][0] = (vert.z < box[2][0]) ? vert.z : box[2][0];
                    box[2][1] = (vert.z > box[2][1]) ? vert.z : box[2][1];
                }
            }

        } /* (p->type == PATCH_QUAD) */

    } /* for (patch = 0; patch < patchmesh->numPatches; patch++) */

    *quadpatches = numquadpatches;
    *tripatches = numtripatches;

    return;
}

static RpGeometry  *
CreateGeometryFromPatch(INode * node, PatchObject * patchObject,
                        RwReal box[3][2], RwInt32 numquadpatches,
                        RwInt32 numtripatches, RpPatch ** outPatch,
                        Matrix3 & maxTransform)
{

    Mtl                *mat;
    MtlID              *mapindex; /* buffer d'index de materiaux */
    RpGeometry         *geom;
    RpMaterial        **rw_mat;
    RpPatch            *patch;
    RwRGBA             *rw_col;
    RwTexCoords        *rw_uv;
    RwV3d              *rw_pos, *rw_nrm;
    RxVertexIndex       cpt[16];
    RwReal              bsmooth = 0.0f;
    RwReal              bweld = 1e-3f;
    RwReal              smoothang = 75.0f;
    RwInt32             i, j, k, l, m;
    RwInt32             mapnumber = 20;
    RwInt32             mapposition = 0;
    RwInt32             numpatches = numtripatches + numquadpatches;
    RwInt32             maxverts = numpatches * 16;
    RwInt32             patchnum = 0;
    RwInt32             src;
    RwInt32             vertnum = 0;
    static RwInt32      bezcount = 0;
    PatchMesh          *patchmesh;

    geom = NULL;

    _ASSERTE(node);
    mat = node->GetMtl();

    _ASSERTE(patchObject);
    patchmesh = &patchObject->patch;

    /*----------- Allocation de memoire ---------------------------- */
    mapindex = (MtlID *) RwMalloc(sizeof(MtlID) * mapnumber);
    _ASSERTE(mapindex);
    rw_pos = (RwV3d *) RwMalloc(sizeof(RwV3d) * maxverts);
    _ASSERTE(rw_pos);
    rw_nrm = (RwV3d *) RwMalloc(sizeof(RwV3d) * maxverts);
    _ASSERTE(rw_nrm);
    rw_uv = (RwTexCoords *) RwMalloc(sizeof(RwTexCoords) * maxverts);
    _ASSERTE(rw_uv);
    rw_col = (RwRGBA *) RwMalloc(sizeof(RwRGBA) * maxverts);
    _ASSERTE(rw_col);
    rw_mat = (RpMaterial **) RwMalloc(sizeof(RpMaterial *) * mapnumber);
    _ASSERTE(rw_mat);
    patch = RpPatchCreate();
    _ASSERTE(patch);

    /*------------ Seek Texture Maps index and number -------------- */
    for (src = 0; src < patchmesh->numPatches; src++)
    {
        Patch              *p;
        MtlID               matid;

        _ASSERTE(patchmesh && patchmesh->patches);
        p = &patchmesh->patches[src];
        _ASSERTE(p);

        matid = p->getMatID();

        /* Find the material. */
        if (mapposition)
        {
            char                oTexName[256];
            Mtl                *fsubMatl;
            Texmap             *ftmap;
            BitmapTex          *fmaxTex;
            char               *ffullTexName;
            char                fTexName[256];
            Mtl                *osubMatl = (mat ?
                                            GetSubMaterial(mat, matid) :
                                            NULL);
            Texmap             *otmap = (osubMatl ?
                                         osubMatl->GetActiveTexmap() :
                                         NULL);
            BitmapTex          *omaxTex = (BitmapTex *) otmap;
            char               *ofullTexName = (omaxTex ?
                                                omaxTex->GetMapName() :
                                                NULL);

            GetTexFileName(oTexName, ofullTexName, 0);
            j = 0;
            m = 0;
            for (i = 0; i < mapposition; i++)
            {
                fsubMatl = (mat ?
                            GetSubMaterial(mat, mapindex[i]) : NULL);
                ftmap = (fsubMatl ? fsubMatl->GetActiveTexmap() : NULL);
                fmaxTex = (BitmapTex *) ftmap;

                ffullTexName = (fmaxTex ? fmaxTex->GetMapName() : NULL);

                GetTexFileName(fTexName, ffullTexName, 0);
                if ((matid == mapindex[i])
                    || (!strcmp(fTexName, oTexName)))
                {
                    j = 1;
                    m = i;
                    break;
                }
            }
            if (j == 0)
            {
                fsubMatl = (mat ? GetSubMaterial(mat, matid) : NULL);
                ftmap = (fsubMatl ? fsubMatl->GetActiveTexmap() : NULL);
                fmaxTex = (BitmapTex *) ftmap;
                ffullTexName = (fmaxTex ? fmaxTex->GetMapName() : NULL);

                k = mapposition + 1;
                if (k >= mapnumber)
                {
                    mapnumber += 20;
                    mapindex =
                        (MtlID *) RwRealloc(mapindex,
                                            sizeof(MtlID) * mapnumber);

                    rw_mat = (RpMaterial **)
                        RwRealloc(rw_mat,
                                  sizeof(RpMaterial *) * mapnumber);
                }

                m = mapposition;

                rw_mat[mapposition] =
                    Max2RpMaterial(fsubMatl, matid, 0);
                mapindex[mapposition] = matid;

                mapposition++;
            }
        }
        else
        {
            Mtl                *osubMatl = GetSubMaterial(mat, matid);

            m = mapposition;

            rw_mat[mapposition] = Max2RpMaterial(osubMatl, matid, 0);
            mapindex[mapposition] = matid;

            mapposition++;
        }

        BezMatrix           B;
        BezMatrix           P;
        RwInt32             uvk;
        RwInt32             chanel = 1;
        RwInt32             tvPatchCount;
        Matrix3             UVtrans;
        UVVert              oldUV;
        UVVert              newUV;
        Mtl                *fsubMatl = (mat ?
                                        GetSubMaterial(mat, matid) :
                                        NULL);
        Texmap             *ftmap = (fsubMatl ?
                                     fsubMatl->GetActiveTexmap() :
                                     NULL);
        BitmapTex          *fmaxTex = (BitmapTex *) ftmap;
        char               *ffullTexName = (fmaxTex ?
                                            fmaxTex->GetMapName() :
                                            NULL);

        GetMaxUVTransform(mat, matid, &UVtrans);

        /* ----------------- triangular patch ----------------------- */
        if (p->type == PATCH_TRI)
        {
            RwReal              b[3];

            for (j = 0; j <= 3; j++)
            {
                b[0] = ((RwReal) j) / ((RwReal)3);
                for (i = 0; i <= (3 - j); i++)
                {
                    b[1] = ((RwReal) i) / ((RwReal)3);
                    b[2] = 1 - (b[0] + b[1]);
                    B[i][j] = p->interp(patchmesh, b[0], b[1], b[2]);
                }
            }

            /* ---- build positions ---- */
            BezTriFit(P, B);
            l = 0;
            for (j = 0; j <= 3; j++)
            {
                for (i = 0; i <= (3 - j); i++)
                {
                    Point3              pptr = P[i][j];

                    cpt[l] = vertnum;

                    pptr = pptr * maxTransform;

                    rw_pos[vertnum].x = pptr.x;
                    rw_pos[vertnum].y = pptr.y;
                    rw_pos[vertnum].z = pptr.z;

                    rw_nrm[vertnum].x = 0.0f;
                    rw_nrm[vertnum].y = 0.0f;
                    rw_nrm[vertnum].z = 0.0f;

                    rw_uv[vertnum].u = 0.0f;
                    rw_uv[vertnum].v = 0.0f;

                    rw_col[vertnum].red = 0;
                    rw_col[vertnum].green = 0;
                    rw_col[vertnum].blue = 0;
                    rw_col[vertnum].alpha = 255;

                    vertnum++;
                    l++;
                }
            }
            for (i = 10; i <= 15; i++)
            {
                cpt[i] = 0;
            }

            /* --- build textcoord ---- */
            tvPatchCount = patchmesh->tvPatches.Count();
            if (tvPatchCount >= 3)
            {

                uvk = patchmesh->tvPatches[chanel][src].tv[0];
                oldUV = patchmesh->getTVert(uvk);
                oldUV.z = 0.0f;
                newUV = oldUV * UVtrans;
                newUV.y = 1.0 - newUV.y;

                rw_uv[cpt[0]].u = newUV.x;
                rw_uv[cpt[0]].v = newUV.y;

                uvk = patchmesh->tvPatches[chanel][src].tv[2];
                oldUV = patchmesh->getTVert(uvk);
                oldUV.z = 0.0f;
                newUV = oldUV * UVtrans;
                newUV.y = 1.0 - newUV.y;

                rw_uv[cpt[3]].u = newUV.x;
                rw_uv[cpt[3]].v = newUV.y;

                uvk = patchmesh->tvPatches[chanel][src].tv[1];
                oldUV = patchmesh->getTVert(uvk);
                oldUV.z = 0.0f;
                newUV = oldUV * UVtrans;
                newUV.y = 1.0 - newUV.y;

                rw_uv[cpt[9]].u = newUV.x;
                rw_uv[cpt[9]].v = newUV.y;
            }
            else
            {
                rw_uv[cpt[0]].u = 0.0f;
                rw_uv[cpt[0]].v = 0.0f;

                rw_uv[cpt[3]].u = 0.0f;
                rw_uv[cpt[3]].v = 0.0f;

                rw_uv[cpt[9]].u = 0.0f;
                rw_uv[cpt[9]].v = 0.0f;

            }

            rw_uv[cpt[5]].u = 1e4;

            RpPatchAddControlIndices(patch, cpt, rw_mat[m], 0);
        }
        /* ----------------- Quad patch ----------------------- */
        else if (p->type == PATCH_QUAD)
        {
            RwReal              b[2];

            for (j = 0; j <= 3; j++)
            {
                b[0] = ((RwReal) j) / ((RwReal)3);
                for (i = 0; i <= 3; i++)
                {
                    b[1] = ((RwReal) i) / ((RwReal)3);
                    B[i][j] = p->interp(patchmesh, b[1], b[0]);
                }
            }
            /* ---- build positions ---- */
            BezQuadFit(P, B);
            l = 0;
            for (j = 0; j <= 3; j++)
            {
                for (i = 0; i <= 3; i++)
                {
                    Point3              pptr = P[i][j];

                    cpt[l] = vertnum;

                    pptr = pptr * maxTransform;

                    rw_pos[vertnum].x = pptr.x;
                    rw_pos[vertnum].y = pptr.y;
                    rw_pos[vertnum].z = pptr.z;

                    rw_nrm[vertnum].x = 0.0f;
                    rw_nrm[vertnum].y = 0.0f;
                    rw_nrm[vertnum].z = 0.0f;

                    rw_uv[vertnum].u = 0.0f;
                    rw_uv[vertnum].v = 0.0f;

                    rw_col[vertnum].red = 0;
                    rw_col[vertnum].green = 0;
                    rw_col[vertnum].blue = 0;
                    rw_col[vertnum].alpha = 255;

                    vertnum++;
                    l++;
                }
            }

            /* --- build textcoord ---- */
            tvPatchCount = patchmesh->tvPatches.Count();
            if (tvPatchCount >= 4)
            {
                uvk = patchmesh->tvPatches[chanel][src].tv[0];
                oldUV = patchmesh->getTVert(uvk);
                oldUV.z = 0.0f;
                newUV = oldUV * UVtrans;
                newUV.y = 1.0 - newUV.y;

                rw_uv[cpt[0]].u = newUV.x;
                rw_uv[cpt[0]].v = newUV.y;

                uvk = patchmesh->tvPatches[chanel][src].tv[3];
                oldUV = patchmesh->getTVert(uvk);
                oldUV.z = 0.0f;
                newUV = oldUV * UVtrans;
                newUV.y = 1.0 - newUV.y;

                rw_uv[cpt[3]].u = newUV.x;
                rw_uv[cpt[3]].v = newUV.y;

                uvk = patchmesh->tvPatches[chanel][src].tv[1];
                oldUV = patchmesh->getTVert(uvk);
                oldUV.z = 0.0f;
                newUV = oldUV * UVtrans;
                newUV.y = 1.0 - newUV.y;

                rw_uv[cpt[12]].u = newUV.x;
                rw_uv[cpt[12]].v = newUV.y;

                uvk = patchmesh->tvPatches[chanel][src].tv[2];
                oldUV = patchmesh->getTVert(uvk);
                oldUV.z = 0.0f;
                newUV = oldUV * UVtrans;
                newUV.y = 1.0 - newUV.y;

                rw_uv[cpt[15]].u = newUV.x;
                rw_uv[cpt[15]].v = newUV.y;
            }
            else
            {

                rw_uv[cpt[0]].u = 0.0f;
                rw_uv[cpt[0]].v = 0.0f;

                rw_uv[cpt[3]].u = 0.0f;
                rw_uv[cpt[3]].v = 0.0f;

                rw_uv[cpt[12]].u = 0.0f;
                rw_uv[cpt[12]].v = 0.0f;

                rw_uv[cpt[15]].u = 0.0f;
                rw_uv[cpt[15]].v = 0.0f;
            }

            rw_uv[cpt[5]].u = 0; /* flag quad. */

            RpPatchAddControlIndices(patch, cpt,
                                     rw_mat[m], RPPATCHFLAGQUAD);
        }
    }

    /* Export the patch as a dff. */
    /* Set the number of control points and copy the verts, normals and uvs. */

    RpPatchSetNumControlPoints(patch, vertnum);

    RpPatchSetControlPoints(patch, rw_pos);
    RpPatchSetNormals(patch, rw_nrm);
    RpPatchSetTexCoords(patch, rw_uv, 0);
    /* RpPatchSetPreLit(patch, rw_col); */

    geom = RpPatchCreateGeometry(patch,
                                 (rpGEOMETRYTEXTURED |
                                  rpGEOMETRYNORMALS |
                                  /* rpGEOMETRYPRELIT | */
                                  rpGEOMETRYLIGHT |
                                  rpGEOMETRYTRISTRIP));

    _ASSERTE(outPatch);
    *outPatch = patch;

    RwFree(rw_mat);
    rw_mat = NULL;

    RwFree(rw_col);
    rw_col = NULL;

    RwFree(rw_uv);
    rw_uv = NULL;

    RwFree(rw_nrm);
    rw_nrm = NULL;

    RwFree(rw_pos);
    rw_pos = NULL;

    RwFree(mapindex);
    mapindex = NULL;

    /* ----------- Liberation des buffers ------------------------------- */
    /*------------------- Close this file ----------------------- */

    return (geom);
}

#endif /* RW_PATCH_EXP */

/* ------------------------------------------------------------------- */

/*
 * See
 * Working with Patches
 * file://\\Hera/Technologies/Doc/MaxSDK/decompil/html/sdk6ybb.htm
 * Class Patch
 * file://\\Hera/Technologies/Doc/MaxSDK/decompil/html/sdk2o17.htm
 *
 * Prototype:
 * Point3 interp(PatchMesh *pMesh, RwReal u, RwReal v);
 * Remarks:
 * Quadrilateral patch interpolator. This method returns a point on the
 * surface of the patch based on the specified u and v values.
 * Parameters:
 * PatchMesh *pMesh
 * Points to the PatchMesh to interpolate.
 * RwReal u
 * The u value in the range 0.0 to 1.0. This defines the distance along one
 * axis of the patch.
 * RwReal v
 * The v value in the range 0.0 to 1.0. This defines the distance along the
 * other axis of the patch.
 * Return Value:
 * A point on the surface of the patch.
 *
 * Prototype:
 * Point3 interp(PatchMesh *pMesh, RwReal u, RwReal v, RwReal w);
 * Remarks:
 * Triangle patch interpolator. This method returns a point on the surface of
 * the patch based on the specified u, v and w values. The u, v, w values are
 * barycentric coordinates. u+v+w = 1.0. If u is 1, and v and w are 0, the
 * point is at the first vertex. If u is 0, v is 1, and w is 0, then the point
 * is at the second vertex. If u and v are 0 and w is 1 then the point is at
 * the third vertex. Varying positions between these values represent
 * different positions on the patch.
 * Parameters:
 * PatchMesh *pMesh
 * Points to the PatchMesh to interpolate.
 * RwReal u, RwReal v, RwReal w
 * The barycentric coordinates.
 * Return Value:
 * A point on the surface of the patch.
 */

void
ExtractGeometryFromPatchNode(INode * node, RpClump * clump,
                             RwFrame * inFrame, RpAtomic * &outAtomic,
                             Matrix3 & transform, TimeValue tvCurrent)
{

#ifdef RW_PATCH_EXP

    RpPatch            *patch;
    RpGeometry         *geometry;

    outAtomic = NULL;

    /*we only build geometry for visible nodes that can be converted to tri meshes. */
    Object             *object = node->EvalWorldState(tvCurrent).obj;

    if (!object || !object->IsRenderable() || !node->Renderable()
        || node->IsNodeHidden()
        || !object->CanConvertToType(triObjectClassID))
    {
        return;
    }

    PatchObject        *patchObject = (PatchObject *)
        object->ConvertToType(tvCurrent, patchObjectClassID);

    if (patchObject)
    {
        RwInt32             numquadpatches = 0;
        RwInt32             numtripatches = 0;
        RwInt32             numpatches = 0;
        RwReal              box[3][2];

        GetBezBox(patchObject, box, &numquadpatches, &numtripatches);

        geometry = CreateGeometryFromPatch(node, 
                                           patchObject,
                                           box,
                                           numquadpatches,
                                           numtripatches, 
                                           &patch,
                                           transform);
    }

    if (geometry)
    {
        /*do we want some morph targets? */
        /*if not just do one key frame */
        /*(which also currently seems to do lighting, normals, texture coords etc!) */
        RwInt32             numKeyFrames = 1;

#if (0)

        if (m_morphTargets)
        {
            /* Count up some more keys to take for morph targets */
            /* This will go wrong when used in conjunction with 
             * skinned animations, */
             * but one day we'd like it to work. */
            /*(so user shouldn't check welding + skinning at same time!!!) */
            Interval            v;

            v = object->ObjectValidity(m_tvStart);
            if (v.Start() > m_tvStart || v.End() < m_tvEnd)
            {
                numKeyFrames = m_nNumFrames / m_nAnimFrameInterval;
                if (numKeyFrames % m_nAnimFrameInterval)
                {
                    numKeyFrames++;
                }
            }
        }

        SetGeometryKeyFramesFromNode(node, geometry, numKeyFrames,
                                     outVertexMap, transform);

#endif /* (0) */

        {
            RpMorphTarget      *keyFrame;
            RwSphere            sphere;

            keyFrame = RpGeometryGetMorphTarget(geometry, 0);

            /* set bounding sphere */
            RpMorphTargetCalcBoundingSphere(keyFrame, &sphere);
            RpMorphTargetSetBoundingSphere(keyFrame, &sphere);
        }

        /* check for coloured materials in the geometry */

#if (0)

        if (GeometryHasColoredMaterials(geometry))
        {
            RpGeometrySetFlags(geometry,
                               RpGeometryGetFlags(geometry) |
                               rpGEOMETRYMODULATEMATERIALCOLOR);
        }

#endif /* (0) */

        outAtomic = RpAtomicCreate();
        if (outAtomic)
        {
            RpAtomicSetFrame(outAtomic, inFrame);
            RpPatchAtomicSetPatchGeometry(outAtomic, patch, geometry);
            RpGeometryDestroy(geometry);
            RpPatchDestroy(patch);
            RpClumpAddAtomic(clump, outAtomic);

#if (0)

            if (GeometryHasMaterialEffects(geometry))
            {
                RpMaterialEffectsEnableAtomic(outAtomic);
            }

#endif /* (0) */

        }
        else
        {
            RpGeometryDestroy(geometry);
            RpPatchDestroy(patch);
        }
    }

#endif /* RW_PATCH_EXP */

    return;

}
